#define BRIGHTNESS 0.05 //-0.03
#define CONTRAST 2.0
#define DESATURATION 0.4

#define X_OFFSET 0.5
#define Z_OFFSET 0.5


//texture tex0 < string ResourceName = "Base.tga"; >;		// Base texture
//texture tex1 < string ResourceName = "Terrain.tga"; >;	// Terrain texture
//texture tex2 < string ResourceName = "Color.dds"; >;		// Color texture
//texture tex3 < string ResourceName = "Alpha.dds"; >;		// Terrain Alpha Mask
//texture tex4 < string ResourceName = "BorderDirection.dds"; >;	// Borders texture
//texture tex5 < string ResourceName = "ProvinceBorders.dds"; >;
//texture tex6 < string ResourceName = "CountryBorders.dds"; >;
//texture tex7 < string ResourceName = "TerraIncog.dds"; >;


float4x4 WorldMatrix		: World; 
float4x4 ViewMatrix		: View; 
float4x4 ProjectionMatrix	: Projection; 
float4x4 AbsoluteWorldMatrix;
float3	 LightDirection;
float	 vAlpha;

sampler BaseTexture  =
sampler_state
{
##	Texture = <tex0>;
	MinFilter = LinearMipMapLinear; //Point;
	MagFilter = Linear; //Point;
	WrapS = Repeat;
	WrapT = Repeat;
};

sampler TreeTexture  =
sampler_state
{
##	Texture = <tex0>;
	MinFilter = Linear; //Point;
	MagFilter = Linear; //Point;
	WrapS = Repeat;
	WrapT = Repeat;
};

sampler MapTexture  =
sampler_state
{
##	Texture = <tex1>;
	MinFilter = LinearMipMapLinear; //Point;
	MagFilter = Linear; //Point;
	WrapS = Repeat;
	WrapT = Repeat;
};

sampler StripesTexture  =
sampler_state
{
##	Texture = <tex1>;
	MinFilter = Linear; //Point;
	MagFilter = Linear; //Point;
	WrapS = Repeat;
	WrapT = Repeat;
};


sampler ColorTexture  =
sampler_state
{
##	Texture = <tex4>;
	MinFilter = Linear;
	MagFilter = Linear;
	WrapS = Repeat;
	WrapT = Repeat;
};

// used for political, religious etc etc..
sampler GeneralTexture  =
sampler_state
{
##	Texture = <tex2>;
	MinFilter = Nearest;
	MagFilter = Nearest;
	WrapS = Repeat;
	WrapT = Repeat;
};

sampler GeneralTexture2  =
sampler_state
{
##	Texture = <tex3>;
	MinFilter = Nearest;
	MagFilter = Nearest;
	WrapS = Repeat;
	WrapT = Repeat;
};


sampler TerrainAlphaTexture  =
sampler_state
{
##	Texture = <tex3>;
	MinFilter = Nearest;
	MagFilter = Nearest;
	WrapS = ClampToEdge;
	WrapT = ClampToEdge;
};

sampler BorderDirectionTexture  =
sampler_state
{
##	Texture = <tex4>;
	MinFilter = Nearest;
	MagFilter = Nearest;
	WrapS = ClampToEdge;
	WrapT = ClampToEdge;
};

sampler WinterTexture  =
sampler_state
{
##	Texture = <tex2>;
	MinFilter = Nearest;
	MagFilter = Nearest;
	WrapS = ClampToEdge;
	WrapT = ClampToEdge;
};


sampler ProvinceBorderTexture  =
sampler_state
{
##	Texture = <tex5>;
	MinFilter = Nearest; //Linear;
	MagFilter = Nearest; //Linear;
	WrapS = ClampToEdge;
	WrapT = ClampToEdge;
};

sampler CountryBorderTexture  =
sampler_state
{
##	Texture = <tex6>;
	MinFilter = Nearest; //Linear;
	MagFilter = Nearest; //Linear;
	WrapS = ClampToEdge;
	WrapT = ClampToEdge;
};

sampler BorderDiagTexture  =
sampler_state
{
##	Texture = <tex1>;
	MinFilter = Nearest; //Linear;
	MagFilter = Nearest; //Linear;
	WrapS = ClampToEdge;
	WrapT = ClampToEdge;
};


sampler TerraIncognitaTextureTerrain =
sampler_state
{
##	Texture = <tex7>;
	MinFilter = Linear;
	MagFilter = Linear;
	WrapS = ClampToEdge;
	WrapT = ClampToEdge;
};

sampler TerraIncognitaTextureTree =
sampler_state
{
##	Texture = <tex1>;
	MinFilter = Linear;
	MagFilter = Linear;
	WrapS = ClampToEdge;
	WrapT = ClampToEdge;
};


struct VS_INPUT
{
    float4 vPosition  : POSITION;
    float3 vNormal    : NORMAL;
    float2 vTexCoord  : TEXCOORD0;
    float2 vProvinceIndexCoord  : TEXCOORD1;
};

struct VS_INPUT_BEACH
{
    float4 vPosition  : POSITION;
    float3 vNormal    : NORMAL;

    float2 vProvinceIndexCoord  : TEXCOORD0;
};

struct VS_OUTPUT
{
    float4  vPosition : POSITION;
    float3  vTexCoord0 : TEXCOORD0;	// third beein' lightIntensity
    float2  vTexCoord1 : TEXCOORD1;
    float2  vColorTexCoord : TEXCOORD2;

    float2  vBorderTexCoord0 : TEXCOORD3;
    float2  vBorderTexCoord1 : TEXCOORD4;

    float2  vTerrainTexCoord : TEXCOORD5;

    float2 vProvinceIndexCoord  : TEXCOORD6;
};

struct VS_OUTPUT_BEACH
{
    float4  vPosition : POSITION;
    float2  vTexCoordBase : TEXCOORD0;
    float2  vColorTexCoord : TEXCOORD1;
	// Later put this into ONE texcoord, this is easier for debugging etc..
    float3  vLightIntensity : TEXCOORD2;
    float2 vProvinceIndexCoord  : TEXCOORD3;
	float2 vBorderTexCoord0		: TEXCOORD4;
};

struct VS_INPUT_PTI
{
    float4 vPosition  : POSITION;
};

struct VS_OUTPUT_PTI
{
    float4  vPosition : POSITION;
};


struct VS_INPUT_TREE
{
    float4 vPosition : POSITION;
    float2 vTexCoord : TEXCOORD0;
};

struct VS_OUTPUT_TREE
{
    float4 vPosition   : POSITION;
    float2 vTexCoord   : TEXCOORD0;
    float2 vTexCoordTI : TEXCOORD1;
};

/////////////////////////////////////////////////////////////////////////////////



VS_OUTPUT VertexShader_Map_General(const VS_INPUT v )
{
	VS_OUTPUT Out = (VS_OUTPUT)0;

	float4x4 WorldView = mul(WorldMatrix, ViewMatrix);
	float3 P = mul(v.vPosition, (float4x3)WorldView);
	Out.vPosition  = mul(float4(P, 1), ProjectionMatrix);

	float3 VertexNormal = (float3)mul( v.vNormal, (float3x4)WorldMatrix );
	float3 direction = normalize( LightDirection );
	Out.vTexCoord0.xy = v.vTexCoord;
	Out.vTexCoord0.z = max( dot( VertexNormal, -direction ), 0.5f );
	Out.vTexCoord1  = v.vTexCoord;

	Out.vProvinceIndexCoord = v.vProvinceIndexCoord;

	float4 WorldPosition = mul( v.vPosition, AbsoluteWorldMatrix );

	float2 TerrainCoord = WorldPosition.xz;
	TerrainCoord += 0.5;
	TerrainCoord /= 8.0;
	Out.vTerrainTexCoord  = TerrainCoord;

	Out.vBorderTexCoord0 = float2( WorldPosition.x/2048.0f, WorldPosition.z/1024.0f );

	return Out;
}



float4 PixelShader_Map2_0_General( VS_OUTPUT v ) : COLOR
{
	float4 BaseColor = tex2D( BaseTexture, v.vTerrainTexCoord.xy );
	float4 Color1 = tex2D( GeneralTexture, v.vProvinceIndexCoord.xy ) +(-0.7);
	float4 Color2 = tex2D( GeneralTexture2, v.vProvinceIndexCoord.xy ) +(-0.7);

	float vColor = tex2D( StripesTexture, v.vTerrainTexCoord.xy ).r;
	float4 Color = Color2 * vColor + Color1 * ( 1.0 +(-vColor) );

	float4 OutColor = BaseColor;

	OutColor.rgb *= v.vTexCoord0.z;

	float Grey = dot( OutColor.rgb, float3( 0.212671f, 0.715160f, 0.072169f ) );
	OutColor.rgb = Grey.rrr;

	OutColor.rgb += Color.rgb;
	OutColor.a = 1;

	float4 ColorTI = tex2D( ColorTexture, v.vBorderTexCoord0.xy );
	OutColor.rgb += ColorTI.a*2;

	// Terra incognita
	float4 TerraIncognita = tex2D( TerraIncognitaTextureTerrain, v.vBorderTexCoord0.xy );
	OutColor.rgb += ( TerraIncognita.g +(-0.25) )*1.33;

	return OutColor;
}




VS_OUTPUT_BEACH VertexShader_Beach_General(const VS_INPUT_BEACH v )
{
	VS_OUTPUT_BEACH Out = (VS_OUTPUT_BEACH)0;
	float4x4 WorldView = mul(WorldMatrix, ViewMatrix);
	float3 P = mul(v.vPosition, (float4x3)WorldView);
	Out.vPosition  = mul(float4(P, 1), ProjectionMatrix);

	float3 VertexNormal = (float3)mul( v.vNormal, (float3x4)WorldMatrix );

	float3 direction = normalize( LightDirection );
	Out.vLightIntensity.xy = max( dot( VertexNormal, -direction ), 0.5f );
	Out.vLightIntensity.z = v.vPosition.y;

	Out.vProvinceIndexCoord = v.vProvinceIndexCoord;

	float4 WorldPosition = mul( v.vPosition, AbsoluteWorldMatrix );
	Out.vColorTexCoord.xy = float2( WorldPosition.x/2048.0f, WorldPosition.z/1024.0f );

	float2 TerrainCoord = WorldPosition.xz;
	TerrainCoord += 0.5;
	TerrainCoord /= 8.0;
	Out.vTexCoordBase  = TerrainCoord;

	Out.vBorderTexCoord0 = float2( WorldPosition.x/2048.0f, WorldPosition.z/1024.0f );

	return Out;
}

float4 PixelShader_Beach_General( VS_OUTPUT_BEACH v ) : COLOR
{
	float4 BaseColor = tex2D( BaseTexture, v.vTexCoordBase.xy );
	float4 Color = tex2D( GeneralTexture, v.vProvinceIndexCoord.xy ) +(-0.7);

	float4 OutColor = BaseColor;

	OutColor.rgb *= v.vLightIntensity.x;

	float Grey = dot( OutColor.rgb, float3( 0.212671f, 0.715160f, 0.072169f ) );
	OutColor.rgb = Grey.rrr;

	OutColor.rgb += Color.rgb;

	float vAlpha = 1;
	if ( v.vLightIntensity.z < 0.3f )
	{
		vAlpha = 1.2;
		vAlpha += ( v.vLightIntensity.z +(-0.3f))*0.7f;
		vAlpha = saturate( vAlpha );	
		vAlpha *= vAlpha;
	}

	// Terra incognita
	float4 TerraIncognita = tex2D( TerraIncognitaTextureTerrain, v.vBorderTexCoord0.xy );
	OutColor.rgb += ( TerraIncognita.g +(-0.25) )*1.33;

	OutColor.a = vAlpha;

	return OutColor;
}


/////////////////////////////////////////////////////////////////////////////////

VS_OUTPUT VertexShader_Map_Border(const VS_INPUT v )
{
	VS_OUTPUT Out = (VS_OUTPUT)0;

	float4x4 WorldView = mul(WorldMatrix, ViewMatrix);
	float3 P = mul(v.vPosition, (float4x3)WorldView);
	Out.vPosition  = mul(float4(P, 1), ProjectionMatrix);

	float4 WorldPosition = mul( v.vPosition, AbsoluteWorldMatrix );

	float2 TerrainCoord = WorldPosition.xz;
//	TerrainCoord += 0.5;
	TerrainCoord /= 8.0;
	Out.vTerrainTexCoord  = TerrainCoord;

	Out.vBorderTexCoord0 = float2( ( WorldPosition.x + 0.5 )/2048.0f, ( WorldPosition.z + 0.5 ) /1024.0f );
	Out.vBorderTexCoord1 = float2( WorldPosition.x, WorldPosition.z );

	return Out;
}


float4 PixelShader_Map2_0_Border( VS_OUTPUT v ) : COLOR
{
	float4 BorderDirectionColor = tex2D( BorderDirectionTexture, v.vBorderTexCoord0.xy );
	float2 TexCoord = v.vBorderTexCoord1;

	TexCoord += 0.5;

//	TexCoord %= 1;				// 0 => 1 range.. only thing we need is the decimal part.
	TexCoord = fmod(TexCoord, 1.0);
	TexCoord.y = 1.0 +(-TexCoord.y);
	TexCoord.x /= 16;
	TexCoord.x *= 0.8; //75;
	float2 TexCoord2 = TexCoord;
	float2 TexCoord3 = TexCoord;

	TexCoord.x += BorderDirectionColor.b;
	float4 ProvinceBorder = tex2D( ProvinceBorderTexture, TexCoord.xy );

	TexCoord2.x += BorderDirectionColor.r;
	float4 CountryBorder = tex2D( CountryBorderTexture, TexCoord2.xy );

	TexCoord3.x += BorderDirectionColor.a;
	float4 DiagBorder = tex2D( BorderDiagTexture, TexCoord3.xy );

	ProvinceBorder.rgb *= ProvinceBorder.a;
	CountryBorder.rgb *= CountryBorder.a;
	DiagBorder.rgb *= DiagBorder.a;

	float4 OutColor;
	OutColor.rgb = ProvinceBorder.rgb*ProvinceBorder.a;
	OutColor.a = max( ProvinceBorder.a, CountryBorder.a );
	OutColor.a = max( OutColor.a, DiagBorder.a );
	OutColor.rgb = CountryBorder.rgb * CountryBorder.a + OutColor.rgb*( 1.0f +(-CountryBorder.a) );
	OutColor.rgb = max( OutColor.rgb, DiagBorder.rgb );

	// Terra incognita
	float4 TerraIncognita = tex2D( TerraIncognitaTextureTerrain, v.vBorderTexCoord0.xy );
	OutColor.rgb += ( TerraIncognita.g +(-0.25) )*1.33;

	return OutColor;
}


float4 PixelShader_Map2_0_BorderGMA950( VS_OUTPUT v ) : COLOR
{
	float4 BorderDirectionColor = tex2D( BorderDirectionTexture, v.vBorderTexCoord0.xy );
	float2 TexCoord = v.vBorderTexCoord1;

	TexCoord += 0.5;
	TexCoord.y += 0.01;	// KGPORT fix for aliasing issue

//	TexCoord %= 1;				// 0 => 1 range.. only thing we need is the decimal part.
	TexCoord = fmod(TexCoord, 1.0);
	TexCoord.y = 1.0 +(-TexCoord.y);
	TexCoord.x /= 16;
	TexCoord.x *= 0.8; //75;
	float2 TexCoord2 = TexCoord;
	float2 TexCoord3 = TexCoord;

	TexCoord.x += BorderDirectionColor.b;
	float4 ProvinceBorder = tex2D( ProvinceBorderTexture, TexCoord.xy );

	TexCoord2.x += BorderDirectionColor.r;
	float4 CountryBorder = tex2D( CountryBorderTexture, TexCoord2.xy );

	TexCoord3.x += BorderDirectionColor.a;
	float4 DiagBorder = tex2D( BorderDiagTexture, TexCoord3.xy );

	ProvinceBorder.rgb *= ProvinceBorder.a;
	CountryBorder.rgb *= CountryBorder.a;
	DiagBorder.rgb *= DiagBorder.a;

	float4 OutColor;
	OutColor.rgb = ProvinceBorder.rgb*ProvinceBorder.a;
	OutColor.a = max( ProvinceBorder.a, CountryBorder.a );
	OutColor.a = max( OutColor.a, DiagBorder.a );
	OutColor.rgb = CountryBorder.rgb * CountryBorder.a + OutColor.rgb*( 1.0f +(-CountryBorder.a) );
	OutColor.rgb = max( OutColor.rgb, DiagBorder.rgb );

	// Terra incognita
	float4 TerraIncognita = tex2D( TerraIncognitaTextureTerrain, v.vBorderTexCoord0.xy );
	OutColor.rgb += ( TerraIncognita.g +(-0.25) )*1.33;

	return OutColor;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////

VS_OUTPUT VertexShader_Map(const VS_INPUT v )
{
	VS_OUTPUT Out = (VS_OUTPUT)0;

	float4x4 WorldView = mul(WorldMatrix, ViewMatrix);
	float3 P = mul(v.vPosition, (float4x3)WorldView);
	Out.vPosition  = mul(float4(P, 1), ProjectionMatrix);

	float3 VertexNormal = (float3)mul( v.vNormal, (float3x4)WorldMatrix );

	float3 direction = normalize( LightDirection );
	Out.vTexCoord0.xy = v.vTexCoord;
	Out.vTexCoord0.z = max( dot( VertexNormal, -direction ), 0.5f );
	Out.vTexCoord1  = v.vTexCoord;

	Out.vProvinceIndexCoord = v.vProvinceIndexCoord;

	float4 WorldPosition = mul( v.vPosition, AbsoluteWorldMatrix );
	Out.vColorTexCoord.xy = float2( ( WorldPosition.x + X_OFFSET)/2048.0f, (WorldPosition.z + Z_OFFSET)/1024.0f );

	float2 TerrainCoord = WorldPosition.xz;
	TerrainCoord += 0.5;
	TerrainCoord /= 8.0;
	Out.vTerrainTexCoord  = TerrainCoord;

	Out.vBorderTexCoord0 = float2( WorldPosition.x/2048.0f, WorldPosition.z/1024.0f );

	return Out;
}


float4 PixelShader_Map2_0( VS_OUTPUT v ) : COLOR
{
	float2 tcoords = v.vTexCoord0.xy;
	float4 BaseColor = tex2D( BaseTexture, tcoords );
	float4 TerrainColor = tex2D( MapTexture, v.vTerrainTexCoord.xy );
	float4 Color = tex2D( ColorTexture, v.vColorTexCoord.xy );
	float4 Winter = tex2D( WinterTexture, v.vProvinceIndexCoord.xy )*0.8;
	float TerrainAlpha = tex2D( TerrainAlphaTexture, v.vTexCoord1.xy ).a;

	float4 OutColor = ( TerrainColor.rgba*TerrainAlpha + ( 1.0f +(-TerrainAlpha) ) * BaseColor.rgba );

	OutColor.rgb *= v.vTexCoord0.z;
	OutColor.rgb *= Color.rgb;
	OutColor.a = 1;

//	OutColor.rgb += Winter.rgb;

	OutColor.rgb += BRIGHTNESS;
	OutColor.rgb += (-0.5f);
	OutColor.rgb *= CONTRAST;
	OutColor.rgb += 0.5f;
	float Grey = dot( OutColor.rgb, float3( 0.212671f, 0.715160f, 0.072169f ) );
	OutColor.rgb = lerp( OutColor.rgb, Grey.rrr, DESATURATION );

	OutColor.rgb = lerp( OutColor.rgb, Grey.rrr, Winter.r );
	OutColor.rgb += Winter.rgb*0.15;

	OutColor.rgb += Color.a*2;

	// Terra incognita
	float4 TerraIncognita = tex2D( TerraIncognitaTextureTerrain, v.vBorderTexCoord0.xy );
	OutColor.rgb += ( TerraIncognita.g +(-0.25) )*1.33;

	return OutColor;
}


////////////////////////////////////////////////////////////////////////////////////////////////////////////


VS_OUTPUT_BEACH VertexShader_Beach(const VS_INPUT_BEACH v )
{
	VS_OUTPUT_BEACH Out = (VS_OUTPUT_BEACH)0;
	float4x4 WorldView = mul(WorldMatrix, ViewMatrix);
	float3 P = mul(v.vPosition, (float4x3)WorldView);
	Out.vPosition  = mul(float4(P, 1), ProjectionMatrix);

	float3 VertexNormal = (float3)mul( v.vNormal, (float3x4)WorldMatrix );

	float3 direction = normalize( LightDirection );
	Out.vLightIntensity.xy = max( dot( VertexNormal, -direction ), 0.5f );
	Out.vLightIntensity.z = v.vPosition.y;

	Out.vProvinceIndexCoord = v.vProvinceIndexCoord;

	float4 WorldPosition = mul( v.vPosition, AbsoluteWorldMatrix );
	Out.vColorTexCoord.xy = float2( ( WorldPosition.x + X_OFFSET )/2048.0f, (WorldPosition.z + Z_OFFSET)/1024.0f );

	float2 TerrainCoord = WorldPosition.xz;
	TerrainCoord += 0.5;
	TerrainCoord /= 8.0;
	Out.vTexCoordBase  = TerrainCoord;

	Out.vBorderTexCoord0 = float2( WorldPosition.x/2048.0f, WorldPosition.z/1024.0f );

	return Out;
}

float4 PixelShader_Beach( VS_OUTPUT_BEACH v ) : COLOR
{
	float4 BaseColor = tex2D( BaseTexture, v.vTexCoordBase.xy );
	float4 Color = tex2D( ColorTexture, v.vColorTexCoord.xy );

	float4 OutColor = BaseColor;

	OutColor.rgb *= v.vLightIntensity.x;
	OutColor.rgb *= Color.rgb;

	float vAlpha = 1;

	OutColor.rgb += BRIGHTNESS;
	OutColor.rgb += (-0.5f);
	OutColor.rgb *= CONTRAST;
	OutColor.rgb += 0.5f;
	float Grey = dot( OutColor.rgb, float3( 0.212671f, 0.715160f, 0.072169f ) );
	OutColor.rgb = lerp( OutColor.rgb, Grey.rrr, DESATURATION );

	if ( v.vLightIntensity.z < 0.3f )
	{
		vAlpha = 1.2;
		vAlpha += ( v.vLightIntensity.z +(-0.3f))*0.7f;
		vAlpha = saturate( vAlpha );	
		vAlpha *= vAlpha;
	}

	float4 Winter = tex2D( WinterTexture, v.vProvinceIndexCoord.xy )*0.8;
	OutColor.rgb = lerp( OutColor.rgb, Grey.rrr, Winter.r );
	OutColor.rgb += Winter.rgb*0.15;

	// Terra incognita
	float4 TerraIncognita = tex2D( TerraIncognitaTextureTerrain, v.vBorderTexCoord0.xy );
	OutColor.rgb += ( TerraIncognita.g +(-0.25) )*1.33;

	OutColor.a = vAlpha;

	return OutColor;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////


VS_OUTPUT_PTI VertexShader_PTI(const VS_INPUT_PTI v )
{
	VS_OUTPUT_PTI Out = (VS_OUTPUT_PTI)0;
	float4x4 WorldView = mul(WorldMatrix, ViewMatrix);
	float3 P = mul(v.vPosition, (float4x3)WorldView);
	Out.vPosition  = mul(float4(P, 1), ProjectionMatrix);
	return Out;
}

float4 PixelShader_PTI( VS_OUTPUT_PTI v ) : COLOR
{
	return float4( 1, 1, 1, 1 );
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////

VS_OUTPUT_TREE VertexShader_TREE(const VS_INPUT_TREE v )
{
	VS_OUTPUT_TREE Out = (VS_OUTPUT_TREE)0;
	float4x4 WorldView = mul(WorldMatrix, ViewMatrix);
	float3 P = mul(v.vPosition, (float4x3)WorldView);
	Out.vPosition  = mul(float4(P, 1), ProjectionMatrix);

	float4 WorldPosition = mul( v.vPosition, AbsoluteWorldMatrix );
	Out.vTexCoordTI = float2( WorldPosition.x/2048.0f, WorldPosition.z/1024.0f );

	Out.vTexCoord = v.vTexCoord;

	return Out;
}

float4 PixelShader_TREE( VS_OUTPUT_TREE v ) : COLOR
{
	float4 OutColor = tex2D( TreeTexture, v.vTexCoord.xy );
	float vFOW = ( tex2D( TerraIncognitaTextureTree, v.vTexCoordTI.xy ).g + (-0.25) )*1.33;
	if ( vFOW < 0 )
		OutColor.rgb += vFOW;
	OutColor.a *= vAlpha;
	return OutColor;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////

technique TerrainShader_Graphical
{
	pass p0
	{
		VertexShader = compile arbvp1 VertexShader_Map();
		FragmentProgram = compile arbfp1 PixelShader_Map2_0();
	}
}

technique TerrainShader_General
{
	pass p0
	{
		VertexProgram = compile arbvp1 VertexShader_Map_General();
		FragmentProgram = compile arbfp1 PixelShader_Map2_0_General();
	}
}

technique TerrainShader_Border
{
	pass p0
	{
		VertexProgram = compile arbvp1 VertexShader_Map_Border();
		FragmentProgram = compile arbfp1 PixelShader_Map2_0_Border();
	}
}


technique TerrainShader_BorderGMA950
{
	pass p0
	{
		VertexProgram = compile arbvp1 VertexShader_Map_Border();
		FragmentProgram = compile arbfp1 PixelShader_Map2_0_BorderGMA950();
	}
}


technique BeachShader_Graphical
{
	pass p0
	{
		VertexProgram = compile arbvp1 VertexShader_Beach();
		FragmentProgram = compile arbfp1 PixelShader_Beach();
	}
}


technique BeachShader_General
{
	pass p0
	{
		VertexProgram = compile arbvp1 VertexShader_Beach_General();
		FragmentProgram = compile arbfp1 PixelShader_Beach_General();
	}
}


technique PTIShader
{
	pass p0
	{
//TODO		fvf = XYZ;

		LightEnable[0] = false;
		LightingEnable = false;

		BlendEnable = true;

//TODO		ColorOp[0] = Modulate;
//TODO		ColorArg1[0] = Texture;
//TODO		ColorArg2[0] = current;
  
//TODO		ColorOp[1] = Disable;
//TODO		AlphaOp[1] = Disable;

		VertexProgram = compile arbvp1 VertexShader_PTI();
		FragmentProgram = compile arbfp1 PixelShader_PTI();
	}
}

technique TreeShader
{
	pass p0
	{
		BlendEnable = true;
		AlphaTestEnable = true;

		VertexProgram = compile arbvp1 VertexShader_TREE();
		FragmentProgram = compile arbfp1 PixelShader_TREE();
	}
}
